# Supplementary code for 
# A generalization of the randomized singular value decomposition

The folder contains the code to replicate the numerical experiments of the paper and plot the figures.
It requires MATLAB with the Chebfun package ([https://www.chebfun.org/](https://www.chebfun.org/)).
Below, we provide a short description of each file.

### Matrix_experiment.m
Reproduce the experiment in Fig 2 of the paper to apply the randomized SVD with a covariance matrix selected to be the discretized Green's function of the Laplacian operator.

### gaussianprocess.m
Generate random functions by sample a Gaussian process using a given covariance kernel as a Chebfun2 function or eigenvalues sequence (in this case, the Jacobi kernel is used).

### randomsvd.m
Apply the randomized SVD to return a low-rank approximation to a self-adjoint HS operator.

### HS_experiment.m
Reproduce the experiment in Fig 4 of the paper to apply the randomized SVD to HS operators with different covariance kernels.

### Data folder
Contains the csv files used to plot the different figures.